/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCDlparClient;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PITaggedIODataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIHardwareConfigurationChange {
    private static final int NUM_VALID_PARMS = 19;
    private String m_forceFlag;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_operation;
    private String m_resourceSubType;
    private String m_sourcePartitionName;
    private String m_sourcePartitionID;
    private String m_sourcePartitionType;
    private String m_targetPartitionName;
    private String m_targetPartitionType;
    private String m_targetPartitionID;
    private String m_slot;
    private String m_slotLocCode;
    private String m_attrs;
    private int m_memQuantity = 0;
    private int m_timeout = 5;
    private short m_detailLevel = 1;
    private HashMap m_parms;
    private boolean m_noRMCConnection = false;
    private String RPA_PARTITION = "RPA_PARTITION";
    private Vector m_attrData;
    private Boolean[] m_taggedIOInfo;
    private int m_procQuantity = 0;
    private long m_procUnitsQuantity = 0L;
    private int m_interactive = 0;
    private String m_delimiter;
    private short m_sharingMode = 0;
    private int m_uncappedWeight = 0;
    private int NO_PROCS = -1;
    private long NO_PROC_UNITS = -1L;
    private short NO_SHARING_MODE = (short)-1;
    private int NO_UNCAPPED_WEIGHT = -1;
    private int NO_INTERACTIVE = -1;
    private short SHARED_CAPPED_VALUE = 0;
    private short SHARED_UNCAPPED_VALUE = 1;
    private short DEDICATED_NORMAL_VALUE = 0;
    private short DEDICATED_KEEP_VALUE = 1;
    private int MIN_UNCAPPED_WEIGHT = 0;
    private int MAX_UNCAPPED_WEIGHT = 255;
    private HashMap m_validParms = new HashMap(39, 0.5f);
    private PIHSCClientObjectFactory theFactory = null;
    private PIHSCCECClient m_CECClient = null;
    private PIHSCLPARClient m_LparClient = null;
    private PIHSCDlparClient m_DlparClient = null;
    private PIHSCDlparClient m_target = null;
    private PIHSCLPARClient m_lparClient = null;
    private static final char s_addOP = 'a';
    private static final char s_moveOP = 'm';
    private static final char s_removeOP = 'r';
    private static final char s_setOP = 's';
    private static final String NONE = "none";
    private static final String SLOT_IO_POOL_ID = "slot_io_pool_id";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIHardwareConfigurationChange(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_writeStatus = bl;
        this.m_out = printStream;
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-o", null);
        this.m_validParms.put("--rsubtype", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("--tid", null);
        this.m_validParms.put("-s", null);
        this.m_validParms.put("-l", null);
        this.m_validParms.put("--procs", null);
        this.m_validParms.put("--procunits", null);
        this.m_validParms.put("--5250cpwpercent", null);
        this.m_validParms.put("-q", null);
        this.m_validParms.put("-w", null);
        this.m_validParms.put("-d", null);
        this.m_validParms.put("-a", null);
        this.m_validParms.put("--force", null);
        this.m_validParms.put("-i", null);
    }

    private int validateMinCapacityLimits(Hashtable hashtable) throws PIHscClientException {
        int n = 0;
        int n2 = 0;
        if (this.m_resourceType.equals("mem")) {
            n2 = (Integer)hashtable.get("pendMinMem");
            n = (Integer)hashtable.get("pendAllocMem");
            if (n - this.m_memQuantity < n2) {
                return n - this.m_memQuantity;
            }
        }
        return -1;
    }

    private Hashtable getMemValues(PIHSCDlparClient pIHSCDlparClient) throws PIHscClientException {
        return pIHSCDlparClient.getMemoryData();
    }

    private int validateMaxCapacityLimits(Hashtable hashtable) throws PIHscClientException {
        int n;
        Object var2_2 = null;
        int n2 = (Integer)hashtable.get("pendAllocMem");
        if (n2 + this.m_memQuantity > (n = ((Integer)hashtable.get("pendMaxMem")).intValue())) {
            return n2 + this.m_memQuantity;
        }
        return -1;
    }

    private long validateQuantity(Hashtable hashtable) throws PIHscClientException {
        long l = (Long)hashtable.get("availMem");
        if (l < (long)this.m_memQuantity) {
            return l;
        }
        return -1L;
    }

    private void doCPUOperation() throws PIHscClientException, HSCRMCException {
        System.out.println("doCPUOperation ============ chhwres -r proc ");
        if (this.m_operation.equals("a")) {
            System.out.println("CALLING doAddCpu-----------------------------------------");
            this.doAddCpu();
        } else if (this.m_operation.equals("r")) {
            System.out.println("CALLING doRemoveCpu-----------------------------------------");
            this.doRemoveCpu();
        } else if (this.m_operation.equals("m")) {
            System.out.println("CALLING MoveCpu-----------------------------------------");
            this.doMoveCpu();
        } else if (this.m_operation.equals("s")) {
            System.out.println("CALLING SetCpu-----------------------------------------");
            this.doSetCpu();
        }
    }

    private void doAddCpu() throws PIHscClientException, HSCRMCException {
        Object var1_1 = null;
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"mfg_default_config"});
        System.out.println("The flag for MGMode is : " + pICECDataBean.isMfgDefaultConfig());
        if (!pICECDataBean.isMfgDefaultConfig()) {
            this.validateCpuQuantity("a");
        }
        try {
            this.m_DlparClient.addCpu(this.m_procQuantity, this.m_procUnitsQuantity, this.m_interactive, this.NO_UNCAPPED_WEIGHT, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.NO_SHARING_MODE);
        }
        catch (PIHscClientException pIHscClientException) {
            throw pIHscClientException;
        }
        catch (HSCRMCException hSCRMCException) {
            throw hSCRMCException;
        }
    }

    private void doRemoveCpu() throws PIHscClientException, HSCRMCException {
        Object var1_1 = null;
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"mfg_default_config"});
        System.out.println("The flag for MGMode is : " + pICECDataBean.isMfgDefaultConfig());
        if (!pICECDataBean.isMfgDefaultConfig()) {
            this.validateCpuQuantity("r");
        }
        try {
            this.m_DlparClient.removeCpu(this.m_procQuantity, this.m_procUnitsQuantity, this.m_interactive, this.NO_UNCAPPED_WEIGHT, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.NO_SHARING_MODE);
        }
        catch (PIHscClientException pIHscClientException) {
            throw pIHscClientException;
        }
        catch (HSCRMCException hSCRMCException) {
            throw hSCRMCException;
        }
    }

    private void doMoveCpu() throws PIHscClientException, HSCRMCException {
        Object var1_1 = null;
        this.validateCpuQuantity("m");
        try {
            if (this.m_targetPartitionName != null) {
                this.m_DlparClient.moveCpu(this.m_procQuantity, this.m_procUnitsQuantity, this.m_targetPartitionName, false, this.m_interactive, this.NO_UNCAPPED_WEIGHT, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.NO_SHARING_MODE);
            } else {
                System.out.println("Sending down the target partition ID!");
                this.m_DlparClient.moveCpu(this.m_procQuantity, this.m_procUnitsQuantity, this.m_targetPartitionID, true, this.m_interactive, this.NO_UNCAPPED_WEIGHT, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.NO_SHARING_MODE);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            throw pIHscClientException;
        }
        catch (HSCRMCException hSCRMCException) {
            throw hSCRMCException;
        }
    }

    private void doSetCpu() throws PIHscClientException, HSCRMCException {
        Object var1_1 = null;
        System.out.println("m_attrs = " + this.m_attrs);
        CSVRecord cSVRecord = new CSVRecord(this.m_attrs, true, this.m_delimiter);
        Iterator iterator = cSVRecord.iterator();
        this.m_uncappedWeight = -1;
        this.m_sharingMode = (short)-1;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            System.out.println("attributeName = " + string2);
            System.out.println("attributeValue = " + string3);
            if (string2.length() == 0 || string3.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            if (!"uncap_weight".equals(string2) && !"sharing_mode".equals(string2)) {
                String[] stringArray = new String[]{string2};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
            }
            if ("uncap_weight".equals(string2)) {
                System.out.println("uncapped weight = " + string3);
                this.m_uncappedWeight = Integer.parseInt(string3);
                if (this.m_uncappedWeight < this.MIN_UNCAPPED_WEIGHT || this.m_uncappedWeight > this.MAX_UNCAPPED_WEIGHT) {
                    String[] stringArray = new String[]{string2 + "=" + string3};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
            }
            if (!"sharing_mode".equals(string2)) continue;
            System.out.println("sharing mode = " + string3);
            if ("cap".equals(string3)) {
                this.m_sharingMode = this.SHARED_CAPPED_VALUE;
                this.m_uncappedWeight = 0;
                continue;
            }
            if ("uncap".equals(string3)) {
                this.m_sharingMode = this.SHARED_UNCAPPED_VALUE;
                continue;
            }
            if ("share_idle_procs".equals(string3)) {
                this.m_sharingMode = this.DEDICATED_NORMAL_VALUE;
                continue;
            }
            if ("keep_idle_procs".equals(string3)) {
                this.m_sharingMode = this.DEDICATED_KEEP_VALUE;
                continue;
            }
            String[] stringArray = new String[]{string2 + "=" + string3};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
        System.out.println(" calling setCpu");
        System.out.println("m_sharingMode = " + this.m_sharingMode);
        System.out.println("m_uncappedWeight = " + this.m_uncappedWeight);
        System.out.println("m_interactive = " + this.m_interactive);
        System.out.println("m_timeout " + this.m_timeout);
        System.out.println("m_noRMCConnection " + this.m_noRMCConnection);
        try {
            this.m_DlparClient.setCpu(this.m_sharingMode, this.m_uncappedWeight, this.m_interactive, this.m_timeout, this.m_noRMCConnection);
        }
        catch (PIHscClientException pIHscClientException) {
            System.out.println("caught something  " + pIHscClientException);
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        catch (HSCRMCException hSCRMCException) {
            throw hSCRMCException;
        }
    }

    private void validateCpuQuantity(String string) throws PIHscClientException {
        String[] stringArray = null;
        boolean bl = false;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n4 = 0;
        short s = 0;
        hashtable = this.m_DlparClient.getProcessorData();
        if ("m".equals(string)) {
            hashtable2 = this.m_target.getProcessorData();
        }
        if (255 == (s = ((Short)hashtable.get("CurProcMode")).shortValue())) {
            n4 = ((Long)hashtable.get("CurAvailProcUnits")).intValue();
            n2 = (Integer)hashtable.get("CurMaxProcs");
            n = (Integer)hashtable.get("CurMinProcs");
            n3 = (Integer)hashtable.get("CurAllocProcs");
        } else {
            l3 = (Long)hashtable.get("CurAvailProcUnits");
            System.out.println("availProcUnits = " + l3);
            l2 = (Long)hashtable.get("CurMaxProcUnits");
            l = (Long)hashtable.get("CurMinProcUnits");
            l4 = (Long)hashtable.get("CurAllocProcUnits");
        }
        if ("a".equals(string)) {
            if (255 == s) {
                if (n4 < this.m_procQuantity) {
                    stringArray = new String[]{new Integer(n4).toString()};
                    System.out.println("IN VALIDATE: availProcs < m_procQuantity " + n4 + " " + this.m_procQuantity);
                    throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", stringArray, null);
                }
                if (this.m_procQuantity + n3 > n2) {
                    stringArray = new String[]{new Integer(n2 - n3).toString()};
                    System.out.println("IN VALIDATE: (m_procQuantity + curProcs) > maxProcs " + (this.m_procQuantity + n3) + " " + n2);
                    throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_CPU_MAX", stringArray, null);
                }
            } else {
                if (l3 < this.m_procUnitsQuantity) {
                    stringArray = new String[]{new Long(l3).toString()};
                    throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", stringArray, null);
                }
                if (this.m_procUnitsQuantity + l4 > l2) {
                    stringArray = new String[]{new Long(l2 - l4).toString()};
                    throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_CPU_MAX", stringArray, null);
                }
            }
            System.out.println("IN VALIDATE: successful check for ADD");
            return;
        }
        if (255 == s) {
            if (n3 - this.m_procQuantity < n) {
                stringArray = new String[]{new Integer(n2 - n3).toString()};
                System.out.println("IN VALIDATE: (curProcs - m_procQuantity) < minProcs " + (n3 - this.m_procQuantity) + " " + n);
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_BELOW_CPU_MIN", stringArray, null);
            }
        } else if (l4 - this.m_procUnitsQuantity < l) {
            stringArray = new String[]{new Long(l2 - l4).toString()};
            throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_BELOW_CPU_MIN", stringArray, null);
        }
        if ("r".equals(string)) {
            System.out.println("IN VALIDATE: successful check for REMOVE");
            return;
        }
        short s2 = (Short)hashtable2.get("CurProcMode");
        if (255 == s2) {
            n4 = ((Long)hashtable2.get("CurAvailProcUnits")).intValue();
            n2 = (Integer)hashtable2.get("CurMaxProcs");
            n3 = (Integer)hashtable2.get("CurAllocProcs");
        } else {
            l3 = (Long)hashtable2.get("CurAvailProcUnits");
            l2 = (Long)hashtable2.get("CurMaxProcUnits");
            l4 = (Long)hashtable2.get("CurAllocProcUnits");
        }
        int n5 = 0;
        long l5 = 0L;
        if (255 == s2) {
            if (s != s2) {
                n5 = (int)(this.m_procUnitsQuantity / 100L);
                if (n5 % 1 != 0) {
                    throw new PIHscClientException("8000", "PIDLPARBundle", "COMMAND_LINE_INVALID_PARAMETERS", stringArray, null);
                }
            } else {
                n5 = this.m_procQuantity;
            }
            if (n5 + n3 > n2) {
                stringArray = new String[]{new Integer(n2 - n3).toString()};
                System.out.println("IN VALIDATE: (moveProcs + curProcs) > maxProcs at DESTINATION partition" + (n5 + n3) + " " + n2);
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_CPU_MAX", stringArray, null);
            }
        } else {
            l5 = s != s2 ? (long)(this.m_procQuantity * 100) : this.m_procUnitsQuantity;
            if (l5 + l4 > l2) {
                stringArray = new String[]{new Long(l2 - l4).toString()};
                System.out.println("IN VALIDATE: (moveProcUnits + curProcs) > maxProcs at DESTINATION partition" + (n5 + n3) + " " + n2);
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_CPU_MAX", stringArray, null);
            }
        }
        System.out.println("IN VALIDATE: successful check for MOVE");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doIOOperation() throws PIHscClientException, HSCRMCException {
        System.out.println("in doIOOperation: m_attrs = " + this.m_attrs);
        CSVRecord cSVRecord = null;
        Iterator iterator = null;
        if (this.m_attrs != null) {
            cSVRecord = new CSVRecord(this.m_attrs, true, this.m_delimiter);
            iterator = cSVRecord.iterator();
        }
        if ("s".equals(this.m_operation)) {
            PILPARDataBean pILPARDataBean = this.m_lparClient.getLPARDataBean(new String[]{"resource_config", "tagged_io_info"});
            if (!pILPARDataBean.isOS400() && !"iopool".equals(this.m_resourceSubType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "OPERATION_ONLY_VALID_FOR_OS400", null, null);
            this.m_taggedIOInfo = pILPARDataBean.getTaggedIOInfo();
            if (this.m_taggedIOInfo == null) {
                this.m_taggedIOInfo = new Boolean[6];
            }
            this.doSetOperation();
            return;
        } else {
            Integer[] integerArray = new Integer[]{new Integer(65535)};
            String[] stringArray = new String[]{this.m_slotLocCode};
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = string.indexOf("=");
                    if (n == -1) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                    }
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    System.out.println("attributeName = " + string2);
                    System.out.println("attributeValue = " + string3);
                    if (string2.length() == 0 || string3.length() == 0) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                    }
                    if (!SLOT_IO_POOL_ID.equals(string2)) {
                        String[] stringArray2 = new String[]{string2};
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray2, null);
                    }
                    integerArray[0] = new Integer(string3);
                }
            }
            switch (this.m_operation.charAt(0)) {
                case 'a': {
                    this.m_DlparClient.addIo(stringArray, integerArray, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
                    return;
                }
                case 'r': {
                    this.m_DlparClient.removeIo(stringArray, integerArray, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
                    return;
                }
                case 'm': {
                    if (this.m_targetPartitionName != null) {
                        this.m_DlparClient.moveIo(stringArray, integerArray, this.m_targetPartitionName, false, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
                        return;
                    }
                    this.m_DlparClient.moveIo(stringArray, integerArray, this.m_targetPartitionID, true, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
                    return;
                }
            }
        }
    }

    private void compareMemoryValues(PIHSCDlparClient pIHSCDlparClient) throws PIHscClientException {
        String[] stringArray = null;
        String string = "";
        Hashtable hashtable = this.getMemValues(this.m_DlparClient);
        int n = (Integer)hashtable.get("currAllocMem");
        int n2 = (Integer)hashtable.get("pendAllocMem");
        int n3 = (Integer)hashtable.get("runtimeMem");
        boolean bl = false;
        if (n2 != n) {
            string = "Pending = " + n2 + " and Current = " + n;
            bl = true;
        }
        if (bl && this.m_forceFlag == null) {
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_PEND_CURR_RUNTIME_MISMATCH", stringArray, null);
        }
        if (bl && this.m_forceFlag != null) {
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_PEND_CURR_RUNTIME_MISMATCH", stringArray, null);
        }
        if (bl && this.m_forceFlag == null) {
            return;
        }
    }

    private void doMemOperation() throws PIHscClientException, HSCRMCException {
        String[] stringArray = null;
        int n = 0;
        this.toString("doMemOperation", "starting");
        if (!PIHMCCommandUtils.isMultipleofMemRegions(this.m_CECClient, new UnsignedInt32((long)this.m_memQuantity))) {
            String[] stringArray2 = new String[]{"-q"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_MEM_PARM_VALUE_NOT_MULTIPLE", stringArray2, null);
        }
        if ("a".equals(this.m_operation)) {
            this.toString("doMemOperation", "comparing mem values");
            this.compareMemoryValues(this.m_DlparClient);
            this.toString("doMemOperation", "getting mem values");
            Hashtable hashtable = this.getMemValues(this.m_DlparClient);
            this.toString("doMemOperation", "validating quantities");
            long l = 0L;
            this.toString("doMemOperation", "check for available memory");
            l = this.validateQuantity(hashtable);
            if (l != -1L) {
                stringArray = new String[]{new Integer(n).toString()};
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES_1", stringArray, null);
            }
            this.toString("doMemOperation", "validating max capacity");
            n = this.validateMaxCapacityLimits(hashtable);
            if (n != -1) {
                stringArray = new String[]{new Integer(n).toString()};
                throw new PIHscClientException("8000", "PIDLPARBundle", "ERR_MEM_ADD_MAX_CURRENT_EQUAL", stringArray, null);
            }
            int n2 = (Integer)hashtable.get("pendAllocMem");
            this.toString("doMemOperation", "pendingAllocMem = " + n2);
            try {
                this.toString("doMemOperation", "calling addMem()");
                this.m_DlparClient.addMem(this.m_memQuantity, n2, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
            }
            catch (PIHscClientException pIHscClientException) {
                throw pIHscClientException;
            }
            catch (HSCRMCException hSCRMCException) {
                throw hSCRMCException;
            }
        }
        if ("m".equals(this.m_operation)) {
            this.compareMemoryValues(this.m_DlparClient);
            Hashtable hashtable = this.getMemValues(this.m_DlparClient);
            int n3 = (Integer)hashtable.get("pendAllocMem");
            n = this.validateMinCapacityLimits(hashtable);
            if (n != -1) {
                int n4 = (Integer)hashtable.get("pendMinMem");
                stringArray = new String[]{new Integer(n3 - n4).toString()};
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_BELOW_MEM_MIN", stringArray, null);
            }
            hashtable = this.getMemValues(this.m_target);
            int n5 = (Integer)hashtable.get("pendAllocMem");
            n = this.validateMaxCapacityLimits(hashtable);
            if (n != -1) {
                stringArray = new String[1];
                n = (Integer)hashtable.get("pendMaxMem");
                stringArray[0] = new Integer(n - n5).toString();
                n = 0;
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_ABOVE_MEM_MAX", stringArray, null);
            }
            try {
                if (this.m_targetPartitionName != null) {
                    this.m_DlparClient.moveMem(this.m_memQuantity, n3, n5, this.m_targetPartitionName, false, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.m_sourcePartitionType, this.m_targetPartitionType);
                }
                this.m_DlparClient.moveMem(this.m_memQuantity, n3, n5, this.m_targetPartitionID, true, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, this.m_sourcePartitionType, this.m_targetPartitionType);
            }
            catch (PIHscClientException pIHscClientException) {
                throw pIHscClientException;
            }
            catch (HSCRMCException hSCRMCException) {
                throw hSCRMCException;
            }
        } else if ("r".equals(this.m_operation)) {
            this.compareMemoryValues(this.m_DlparClient);
            Hashtable hashtable = this.getMemValues(this.m_DlparClient);
            int n6 = (Integer)hashtable.get("pendAllocMem");
            this.toString("doMemOperation", "check for minimum value");
            n = this.validateMinCapacityLimits(hashtable);
            if (n != -1) {
                int n7 = (Integer)hashtable.get("pendMinMem");
                stringArray = new String[]{new Integer(n6 - n7).toString()};
                throw new PIHscClientException("8000", "PIDLPARBundle", "DLPAR_BELOW_MEM_MIN", stringArray, null);
            }
            try {
                this.m_DlparClient.removeMem(this.m_memQuantity, n6, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
            }
            catch (PIHscClientException pIHscClientException) {
                throw pIHscClientException;
            }
            catch (HSCRMCException hSCRMCException) {
                throw hSCRMCException;
            }
        }
    }

    private void doVirtualIOOperation() throws PIHscClientException {
        switch (this.m_operation.charAt(0)) {
            case 'a': {
                this.addVirtualIo();
                break;
            }
            case 'r': {
                this.removeVirtualIo();
                break;
            }
            case 's': {
                this.doSetOperation();
                break;
            }
        }
    }

    private void addVirtualIo() throws PIHscClientException {
        if (this.m_resourceSubType.equals("eth")) {
            this.createVirtualEthernet();
        } else if (this.m_resourceSubType.equals("scsi")) {
            this.createVirtualScsi();
        } else if (this.m_resourceSubType.equals("serial")) {
            this.createVirtualSerial();
        } else {
            System.out.println("chhwres " + this.m_resourceSubType + " virtualio not yet implemented");
        }
    }

    private void removeVirtualIo() throws PIHscClientException {
        System.out.println("In removeVirtualIo command line code");
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        int n = (int)PIHardwareConfigurationChange.decodeStrValue(this.m_slot);
        if (n < 2) {
            String[] stringArray = new String[]{this.m_resourceSubType, String.valueOf(n)};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
        }
        vector.addElement(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(this.m_slot)));
        this.m_DlparClient.removeVirtualSlots(vector, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createVirtualEthernet() throws PIHscClientException {
        System.out.println("In createVirtualEthernet");
        String string = "";
        String string2 = "";
        boolean bl = false;
        int n = 0;
        block8: while (true) {
            if (n >= this.m_attrData.size()) {
                return;
            }
            System.out.println("In the for loop index = " + n);
            PIVirtualEthernetDataBean pIVirtualEthernetDataBean = new PIVirtualEthernetDataBean();
            System.out.println("input = \"" + (String)this.m_attrData.get(n) + "\"");
            CSVRecord cSVRecord = new CSVRecord((String)this.m_attrData.get(n), true, this.m_delimiter);
            System.out.println("CSVRecord = \"" + cSVRecord + "\"");
            Iterator iterator = cSVRecord.iterator();
            try {
                pIVirtualEthernetDataBean.setSlotNumber(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(this.m_slot)));
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{"virtual_eth_adapters", this.m_slot};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
            }
            do {
                block24: {
                    UnsignedInt16[] unsignedInt16Array;
                    StringTokenizer stringTokenizer;
                    boolean bl2;
                    String string3;
                    block29: {
                        Object object;
                        block25: {
                            String string4;
                            block28: {
                                void var12_21;
                                block27: {
                                    block26: {
                                        if (!iterator.hasNext()) break block25;
                                        object = (String)iterator.next();
                                        int n2 = ((String)object).indexOf("=");
                                        if (n2 == -1) {
                                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                                        }
                                        string3 = ((String)object).substring(0, n2);
                                        string4 = ((String)object).substring(n2 + 1);
                                        if (string3.length() == 0 || string4.length() == 0) {
                                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                                        }
                                        System.out.println("attributeName = \"" + string3 + "\", attributeValue = \"" + string4 + "\"");
                                        if (!"ieee_virtual_eth".equals(string3)) break block26;
                                        System.out.println("IEEE...");
                                        try {
                                            if ("0".equals(string4)) {
                                                pIVirtualEthernetDataBean.setIeee(new UnsignedInt8(0));
                                                break block24;
                                            }
                                            if (!"1".equals(string4)) {
                                                String[] stringArray = new String[]{this.m_slot, string3, string4};
                                                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                                            }
                                            pIVirtualEthernetDataBean.setIeee(new UnsignedInt8(1));
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            string = string + string3;
                                        }
                                        break block24;
                                    }
                                    if (!"port_vlan_id".equals(string3)) break block27;
                                    System.out.println("Port VLAN ID...");
                                    try {
                                        pIVirtualEthernetDataBean.setPvid(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(string4)));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        string = string + string3;
                                    }
                                    break block24;
                                }
                                if (!"addl_vlan_ids".equals(string3)) break block28;
                                Object var12_18 = null;
                                bl2 = false;
                                if (string4.startsWith("\"") && string4.startsWith("\"")) {
                                    String string5 = string4.substring(1, string4.length());
                                } else {
                                    String string6 = string4;
                                }
                                stringTokenizer = new StringTokenizer((String)var12_21, " ,");
                                unsignedInt16Array = new UnsignedInt16[stringTokenizer.countTokens()];
                                int n3 = 0;
                                break block29;
                            }
                            if ("is_trunk".equals(string3)) {
                                System.out.println("TRUNK adapter ...");
                                if ("0".equals(string4)) {
                                    pIVirtualEthernetDataBean.setTrunk(new UnsignedInt8(0));
                                    break block24;
                                } else {
                                    if (!"1".equals(string4)) {
                                        String[] stringArray = new String[]{this.m_slot, string3, string4};
                                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                                    }
                                    pIVirtualEthernetDataBean.setTrunk(new UnsignedInt8(1));
                                }
                                break block24;
                            } else {
                                string2 = string2 + string3;
                            }
                            break block24;
                        }
                        pIVirtualEthernetDataBean.setRequired(new UnsignedInt8(1));
                        this.validateVirtualEthernet(pIVirtualEthernetDataBean);
                        object = new Vector();
                        ((Vector)object).addElement(pIVirtualEthernetDataBean);
                        this.m_DlparClient.createVirtualAdapter((Vector)object, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, "eth");
                        ++n;
                        continue block8;
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            unsignedInt16Array[n3++] = new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(stringTokenizer.nextToken()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        string = string + string3;
                    }
                    pIVirtualEthernetDataBean.setAdditionalVids(unsignedInt16Array);
                }
                if (string.trim().length() <= 0) continue;
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", new String[]{string}, null);
            } while (string2.trim().length() <= 0);
            break;
        }
        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string2}, null);
    }

    private void createVirtualScsi() throws PIHscClientException {
        System.out.println("In createVirtualScsi");
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.m_attrData.size(); ++i) {
            Object object;
            System.out.println("In the for loop index = " + i);
            PIVirtualSCSIDataBean pIVirtualSCSIDataBean = new PIVirtualSCSIDataBean();
            System.out.println("input = \"" + (String)this.m_attrData.get(i) + "\"");
            CSVRecord cSVRecord = new CSVRecord((String)this.m_attrData.get(i), true, this.m_delimiter);
            System.out.println("CSVRecord = \"" + cSVRecord + "\"");
            Iterator iterator = cSVRecord.iterator();
            try {
                pIVirtualSCSIDataBean.setSlotNumber(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(this.m_slot)));
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{"virtual_scsi_adapters", this.m_slot};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
            }
            while (iterator.hasNext()) {
                block25: {
                    object = (String)iterator.next();
                    int n = ((String)object).indexOf("=");
                    if (n == -1) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                    }
                    String string3 = ((String)object).substring(0, n);
                    String string4 = ((String)object).substring(n + 1);
                    if (string3.length() == 0 || string4.length() == 0) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                    }
                    System.out.println("attributeName = \"" + string3 + "\", attributeValue = \"" + string4 + "\"");
                    if ("adapter_type".equals(string3)) {
                        System.out.println("Device Attr...");
                        try {
                            if ("client".equals(string4.toLowerCase())) {
                                pIVirtualSCSIDataBean.setDeviceAttributes(new UnsignedInt8(0));
                                break block25;
                            }
                            if ("server".equals(string4.toLowerCase())) {
                                pIVirtualSCSIDataBean.setDeviceAttributes(new UnsignedInt8(1));
                                break block25;
                            }
                            String[] stringArray = new String[]{this.m_slot, string3, string4};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string = string + string3;
                        }
                    } else if ("remote_lpar_id".equals(string3)) {
                        System.out.println("Server Part ID...");
                        if ("any".equals(string4)) {
                            pIVirtualSCSIDataBean.setServerPartitionID(PIVirtualSCSIDataBean.DEFAULT_SERVER_PARTITION_ID);
                        } else {
                            try {
                                pIVirtualSCSIDataBean.setServerPartitionID(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(string4)));
                            }
                            catch (NumberFormatException numberFormatException) {
                                string = string + string3;
                            }
                        }
                    } else if ("remote_lpar_name".equals(string3)) {
                        System.out.println("Server Part Name...");
                        pIVirtualSCSIDataBean.setServerPartitionName(string4);
                    } else if ("remote_slot_num".equals(string3)) {
                        System.out.println("Server slot number...");
                        if ("any".equals(string4)) {
                            pIVirtualSCSIDataBean.setServerSlotNumber(PIVirtualSCSIDataBean.DEFAULT_SERVER_SLOT_NUMBER);
                        } else {
                            pIVirtualSCSIDataBean.setServerSlotNumber(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(string4)));
                        }
                    } else {
                        string2 = string2 + string3;
                    }
                }
                if (string.trim().length() > 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", new String[]{string}, null);
                }
                if (string2.trim().length() <= 0) continue;
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string2}, null);
            }
            pIVirtualSCSIDataBean.setRequired(new UnsignedInt8(1));
            this.validateVirtualSCSI(pIVirtualSCSIDataBean);
            object = new Vector();
            ((Vector)object).addElement(pIVirtualSCSIDataBean);
            this.m_DlparClient.createVirtualAdapter((Vector)object, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, "scsi");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createVirtualSerial() throws PIHscClientException {
        System.out.println("In createVirtualSerial");
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < this.m_attrData.size()) {
            Object object;
            System.out.println("In the for loop index = " + n);
            PIVirtualSerialDataBean pIVirtualSerialDataBean = new PIVirtualSerialDataBean();
            System.out.println("input = \"" + (String)this.m_attrData.get(n) + "\"");
            CSVRecord cSVRecord = new CSVRecord((String)this.m_attrData.get(n), true, this.m_delimiter);
            System.out.println("CSVRecord = \"" + cSVRecord + "\"");
            Iterator iterator = cSVRecord.iterator();
            try {
                pIVirtualSerialDataBean.setSlotNumber(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(this.m_slot)));
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{"virtual_serial_adapters", this.m_slot};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
            }
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                int n2 = ((String)object).indexOf("=");
                if (n2 == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string3 = ((String)object).substring(0, n2);
                String string4 = ((String)object).substring(n2 + 1);
                if (string3.length() == 0 || string4.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                System.out.println("attributeName = \"" + string3 + "\", attributeValue = \"" + string4 + "\"");
                if ("adapter_type".equals(string3)) {
                    System.out.println("Device Attr...");
                    if ("client".equals(string4.toLowerCase())) {
                        pIVirtualSerialDataBean.setDeviceAttributes(new UnsignedInt8(0));
                    } else {
                        if (!"server".equals(string4.toLowerCase())) {
                            String[] stringArray = new String[]{this.m_slot, string3, string4};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                        }
                        pIVirtualSerialDataBean.setDeviceAttributes(new UnsignedInt8(1));
                    }
                } else if ("remote_lpar_id".equals(string3)) {
                    System.out.println("Server Part ID...");
                    if ("any".equals(string4)) {
                        pIVirtualSerialDataBean.setServerPartitionID(PIVirtualSerialDataBean.DEFAULT_SERVER_PARTITION_ID);
                    } else {
                        try {
                            pIVirtualSerialDataBean.setServerPartitionID(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(string4)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            string = string + string3;
                        }
                    }
                } else if ("remote_lpar_name".equals(string3)) {
                    System.out.println("Server Part Name...");
                    pIVirtualSerialDataBean.setServerPartitionName(string4);
                } else if ("remote_slot_num".equals(string3)) {
                    System.out.println("Server slot number...");
                    if ("any".equals(string4)) {
                        pIVirtualSerialDataBean.setServerSlotNumber(PIVirtualSerialDataBean.DEFAULT_SERVER_SLOT_NUMBER);
                    } else {
                        pIVirtualSerialDataBean.setServerSlotNumber(new UnsignedInt16((int)PIHardwareConfigurationChange.decodeStrValue(string4)));
                    }
                } else if ("supports_hmc".equals(string3)) {
                    System.out.println("HMC support...");
                    if ("0".equals(string4)) {
                        pIVirtualSerialDataBean.setSupportsHMC(new UnsignedInt8(0));
                    } else {
                        if (!"1".equals(string4)) {
                            String[] stringArray = new String[]{this.m_slot, string3, string4};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                        }
                        pIVirtualSerialDataBean.setSupportsHMC(new UnsignedInt8(1));
                    }
                } else {
                    string2 = string2 + string3;
                }
                if (string.trim().length() > 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", new String[]{string}, null);
                }
                if (string2.trim().length() <= 0) continue;
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string2}, null);
            }
            pIVirtualSerialDataBean.setRequired(new UnsignedInt8(1));
            this.validateVirtualSerial(pIVirtualSerialDataBean);
            object = new Vector();
            ((Vector)object).addElement(pIVirtualSerialDataBean);
            this.m_DlparClient.createVirtualAdapter((Vector)object, this.m_timeout, this.m_detailLevel, this.m_noRMCConnection, "serial");
            ++n;
        }
        return;
    }

    private void doSetOperation() throws PIHscClientException {
        PITaggedIODataBean pITaggedIODataBean = null;
        if ("io".equals(this.m_resourceType)) {
            pITaggedIODataBean = new PITaggedIODataBean();
        }
        CSVRecord cSVRecord = new CSVRecord(this.m_attrs, true, this.m_delimiter);
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.length() == 0 || string3.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
            }
            if ("io".equals(this.m_resourceType)) {
                if ("iopool".equals(this.m_resourceSubType)) {
                    this.doSetIOPoolIds(string2, string3);
                } else {
                    this.doSetTaggedIO(pITaggedIODataBean, string2, string3);
                }
            }
            if ("eth".equals(this.m_resourceSubType)) {
                this.doSetVirtualEth(string2, string3);
                continue;
            }
            if (!"hsl".equals(this.m_resourceSubType) && !"virtualopti".equals(this.m_resourceSubType)) continue;
            this.doSetOptiConnect(string2, string3);
        }
        if ("io".equals(this.m_resourceType) && !"iopool".equals(this.m_resourceSubType)) {
            pITaggedIODataBean.setTaggedIOInfo(this.m_taggedIOInfo);
            this.m_lparClient.setTaggedIOs(pITaggedIODataBean);
        }
    }

    private void doSetIOPoolIds(String string, String string2) throws PIHscClientException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string3 = null;
        Vector<String> vector = null;
        int n = 0;
        CSVRecord cSVRecord = new CSVRecord(string2);
        Vector vector2 = cSVRecord.getContainer();
        if (string.equals("lpar_io_pool_ids+")) {
            int n2;
            stringArray = this.m_lparClient.getLparIOPools();
            stringArray2 = new String[vector2.size() + stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[n] = stringArray[n2];
                ++n;
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                stringArray2[n] = (String)vector2.get(n2);
                ++n;
            }
        } else if (string.equals("lpar_io_pool_ids-")) {
            int n3;
            stringArray = this.m_lparClient.getLparIOPools();
            vector = new Vector<String>();
            boolean bl = false;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                for (int i = 0; i < vector2.size(); ++i) {
                    string3 = (String)vector2.get(i);
                    if (!string3.equals(stringArray[n3])) continue;
                    bl = true;
                }
                if (!bl) {
                    vector.add(stringArray[n3]);
                }
                bl = false;
            }
            stringArray2 = new String[vector.size()];
            for (n3 = 0; n3 < vector.size(); ++n3) {
                stringArray2[n3] = (String)vector.get(n3);
            }
        } else if (string.equals("lpar_io_pool_ids")) {
            if (1 == vector2.size()) {
                string3 = (String)vector2.get(0);
                stringArray2 = string3.equals(NONE) ? new String[]{} : new String[]{string3};
            } else {
                stringArray2 = new String[vector2.size()];
                for (int i = 0; i < vector2.size(); ++i) {
                    stringArray2[i] = (String)vector2.get(i);
                }
            }
        }
        this.m_lparClient.setLparIOPools(stringArray2);
    }

    private void doSetTaggedIO(PITaggedIODataBean pITaggedIODataBean, String string, String string2) throws PIHscClientException {
        block15: {
            try {
                if ("load_source_slot".equals(string)) {
                    String string3 = PIHMCCommandUtils.decodeTaggedIOSlot(string2).toString();
                    pITaggedIODataBean.setLsSlot(string3);
                    this.m_taggedIOInfo[0] = PIHMCCommandUtils.getTaggedIOType(string3);
                    break block15;
                }
                if ("alt_restart_device_slot".equals(string)) {
                    if (!NONE.equals(string2.toLowerCase())) {
                        String string4 = PIHMCCommandUtils.decodeTaggedIOSlot(string2).toString();
                        pITaggedIODataBean.setAltLsSlot(string4);
                        this.m_taggedIOInfo[1] = PIHMCCommandUtils.getTaggedIOType(string4);
                    } else {
                        pITaggedIODataBean.setAltLsSlot(String.valueOf(0));
                        this.m_taggedIOInfo[1] = new Boolean(false);
                    }
                    break block15;
                }
                if ("console_slot".equals(string)) {
                    if (!"hmc".equals(string2.toLowerCase())) {
                        String string5 = PIHMCCommandUtils.decodeTaggedIOSlot(string2).toString();
                        pITaggedIODataBean.setConsoleSlot(string5);
                        this.m_taggedIOInfo[2] = PIHMCCommandUtils.getTaggedIOType(string5);
                    } else {
                        pITaggedIODataBean.setConsoleSlot(String.valueOf(1));
                        this.m_taggedIOInfo[2] = new Boolean(true);
                    }
                    break block15;
                }
                if ("alt_console_slot".equals(string)) {
                    if (!NONE.equals(string2.toLowerCase())) {
                        String string6 = PIHMCCommandUtils.decodeTaggedIOSlot(string2).toString();
                        pITaggedIODataBean.setAltConsoleSlot(string6);
                        this.m_taggedIOInfo[3] = PIHMCCommandUtils.getTaggedIOType(string6);
                    } else {
                        pITaggedIODataBean.setAltConsoleSlot(String.valueOf(0));
                        this.m_taggedIOInfo[3] = new Boolean(false);
                    }
                    break block15;
                }
                if ("op_console_slot".equals(string)) {
                    if (!NONE.equals(string2.toLowerCase())) {
                        String string7 = PIHMCCommandUtils.decodeTaggedIOSlot(string2).toString();
                        pITaggedIODataBean.setEcsSlot(string7);
                        this.m_taggedIOInfo[4] = PIHMCCommandUtils.getTaggedIOType(string7);
                    } else {
                        pITaggedIODataBean.setEcsSlot(String.valueOf(0));
                        this.m_taggedIOInfo[4] = new Boolean(false);
                    }
                    break block15;
                }
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{string + "=" + string2};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
            }
        }
    }

    private void doSetVirtualEth(String string, String string2) throws PIHscClientException {
        boolean bl = false;
        if ("mac_prefix".equals(string)) {
            if (string2.length() == 6) {
                try {
                    Integer.parseInt(string2, 16);
                    this.m_CECClient.setVirtualEthernetMACAddressPrefix(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
        }
        if (bl) {
            String[] stringArray = new String[]{string + "=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
    }

    private void doSetOptiConnect(String string, String string2) throws PIHscClientException {
        boolean bl = false;
        if (!this.m_LparClient.getLPARDataBean(new String[]{"resource_config"}).isOS400()) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "OPERATION_ONLY_VALID_FOR_OS400", null, null);
        }
        if ("hsl".equals(this.m_resourceSubType) && "hsl_pool_id".equals(string) || "virtualopti".equals(this.m_resourceSubType) && "virtual_opti_pool_id".equals(string)) {
            try {
                this.m_LparClient.setOptiConnect(new UnsignedInt8(string2), "hsl".equals(this.m_resourceSubType));
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        } else {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
        }
        if (bl) {
            String[] stringArray = new String[]{string + "=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
    }

    private void validateVirtualEthernet(PIVirtualEthernetDataBean pIVirtualEthernetDataBean) throws PIHscClientException {
        System.out.println("In validateVirtualEthernet ");
        PILPARDataBean pILPARDataBean = this.m_LparClient.getLPARDataBean(new String[]{"curr_max_virtual_slots"});
        int n = pILPARDataBean.getCurMaxVirtualIO().intValue();
        System.out.println("The max virtual slot from parition is :" + n);
        int n2 = pIVirtualEthernetDataBean.getSlotNumber().intValue();
        if (n2 < 2 || n2 >= n) {
            String[] stringArray = new String[]{"virtual_eth_adapters", String.valueOf(n2)};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
        }
        UnsignedInt16 unsignedInt16 = pIVirtualEthernetDataBean.getPvid();
        System.out.println("The VLAN ID is :" + unsignedInt16);
        if (unsignedInt16 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "port_vlan_id"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        int n3 = unsignedInt16.intValue();
        System.out.println("The portVlanID is :" + n3);
        if (n3 < 1 || n3 > 4094) {
            System.out.println("Validating vlan id");
            String[] stringArray = new String[]{String.valueOf(n2), "port_vlan_id", String.valueOf(n3)};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        UnsignedInt8 unsignedInt8 = pIVirtualEthernetDataBean.getRequired();
        System.out.println("The Required value is " + unsignedInt8);
        if (unsignedInt8 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "is_required"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        UnsignedInt8 unsignedInt82 = pIVirtualEthernetDataBean.getTrunk();
        System.out.println("The Trunk value is " + unsignedInt82);
        if (unsignedInt82 == null) {
            pIVirtualEthernetDataBean.setTrunk(new UnsignedInt8(0));
        }
        UnsignedInt8 unsignedInt83 = pIVirtualEthernetDataBean.getIeee();
        System.out.println("The ieee value is :" + unsignedInt83);
        if (unsignedInt83 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "ieee_virtual_eth"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        UnsignedInt16[] unsignedInt16Array = pIVirtualEthernetDataBean.getAdditionalVids();
        if (unsignedInt16Array != null && unsignedInt16Array.length != 0) {
            System.out.println("Validating additional vlan ids");
            if (unsignedInt83.shortValue() == 0) {
                String[] stringArray = new String[]{String.valueOf(n2)};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ADDL_VLAN_IDS_NOT_ALLOWED", stringArray, null);
            }
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"max_vlans_per_port"});
            if (unsignedInt16Array.length >= pICECDataBean.getMaxVLANIDsPerPort().intValue()) {
                String[] stringArray = new String[]{String.valueOf(n2), pICECDataBean.getMaxVLANIDsPerPort().toString()};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "TOO_MANY_VLAN_IDS", stringArray, null);
            }
            for (int i = 0; i < unsignedInt16Array.length; ++i) {
                int n4 = unsignedInt16Array[i].intValue();
                if (n4 < 2 || n4 > 4094) {
                    String[] stringArray = new String[]{String.valueOf(n2), "addl_vlan_ids", String.valueOf(n4)};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
                }
                if (n4 == n3) {
                    String[] stringArray = new String[]{String.valueOf(n2)};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_VLAN_IDS", stringArray, null);
                }
                for (int j = i + 1; j < unsignedInt16Array.length; ++j) {
                    if (n4 != unsignedInt16Array[j].intValue()) continue;
                    String[] stringArray = new String[]{String.valueOf(n2)};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_VLAN_IDS", stringArray, null);
                }
            }
        }
        System.out.println("The Virtual Ethernet Validation is complete");
    }

    private void validateVirtualSCSI(PIVirtualSCSIDataBean pIVirtualSCSIDataBean) throws PIHscClientException {
        UnsignedInt16 unsignedInt16;
        Object object;
        PIHSCLPARClient pIHSCLPARClient = null;
        System.out.println("In validateVirtualSCSI");
        PILPARDataBean pILPARDataBean = this.m_LparClient.getLPARDataBean(new String[]{"curr_max_virtual_slots"});
        int n = pILPARDataBean.getCurMaxVirtualIO().intValue();
        System.out.println("The max virtual slot from parition is :" + n);
        int n2 = pIVirtualSCSIDataBean.getSlotNumber().intValue();
        System.out.println("The virtual slot number is :" + n2);
        if (n2 < 2 || n2 >= n) {
            String[] stringArray = new String[]{"virtual_scsi_adapters", String.valueOf(n2)};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
        }
        UnsignedInt8 unsignedInt8 = pIVirtualSCSIDataBean.getDeviceAttributes();
        if (unsignedInt8 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "adapter_type"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        boolean bl = unsignedInt8.intValue() == 1;
        UnsignedInt16 unsignedInt162 = pIVirtualSCSIDataBean.getServerPartitionID();
        String string = pIVirtualSCSIDataBean.getServerPartitionName();
        UnsignedInt16 unsignedInt163 = pIVirtualSCSIDataBean.getServerSlotNumber();
        UnsignedInt8 unsignedInt82 = pIVirtualSCSIDataBean.getRequired();
        System.out.println("The is Server value is :" + bl);
        System.out.println("The serverLparID value is :" + unsignedInt162);
        System.out.println("The serverLpar Name is " + string);
        System.out.println("The Server slot num is " + unsignedInt163);
        System.out.println("The Required value is " + unsignedInt82);
        if (unsignedInt82 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "is_required"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        if (bl) {
            System.out.println("Validating server");
            object = null;
            unsignedInt16 = null;
            if ((unsignedInt162 != null || string != null) && unsignedInt163 == null) {
                object = "remote_slot_num";
            } else if (unsignedInt163 != null && unsignedInt162 == null && string == null) {
                object = "remote_lpar_id | remote_lpar_name";
            }
            if (object != null) {
                String[] stringArray = new String[]{String.valueOf(n2), object};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
            }
            if (unsignedInt163 == null) {
                pIVirtualSCSIDataBean.setServerPartitionID(PIVirtualSCSIDataBean.DEFAULT_SERVER_PARTITION_ID);
                pIVirtualSCSIDataBean.setServerSlotNumber(PIVirtualSCSIDataBean.DEFAULT_SERVER_SLOT_NUMBER);
            }
        } else {
            System.out.println("Validating client");
            object = "";
            if (unsignedInt162 == null && string == null) {
                object = "remote_lpar_id | remote_lpar_name";
            }
            if (unsignedInt163 == null) {
                object = (String)object + ", remote_slot_num";
            }
            if (((String)object).length() > 0) {
                if (((String)object).startsWith(", ")) {
                    object = ((String)object).substring(2, ((String)object).length());
                }
                String[] stringArray = new String[]{String.valueOf(n2), object};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
            }
        }
        System.out.println("Checking the validity of the serverpartitionName");
        if (string != null && unsignedInt162 == null) {
            pIHSCLPARClient = this.theFactory.createLPARClient(this.m_managedSystem, string, false);
            System.out.println("The lpar client for server parititon name is :" + pIHSCLPARClient);
            if (pIHSCLPARClient == null) {
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
            object = pIHSCLPARClient.getLPARDataBean(new String[]{"lpar_id"});
            unsignedInt16 = ((PILPARDataBean)object).getLparID();
            System.out.println("The serverPartition ID is :" + unsignedInt16);
            pIVirtualSCSIDataBean.setServerPartitionID(unsignedInt16);
        }
        if (unsignedInt163 != null && unsignedInt163.intValue() < 2) {
            System.out.println("Validating remote slot number");
            object = "";
            String[] stringArray = new String[]{String.valueOf(n2), "remote_slot_num", unsignedInt163.toString()};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
    }

    private void validateVirtualSerial(PIVirtualSerialDataBean pIVirtualSerialDataBean) throws PIHscClientException {
        String string;
        Object object;
        PIHSCLPARClient pIHSCLPARClient = null;
        System.out.println("In validateVirtualSerial");
        PILPARDataBean pILPARDataBean = this.m_LparClient.getLPARDataBean(new String[]{"curr_max_virtual_slots"});
        int n = pILPARDataBean.getCurMaxVirtualIO().intValue();
        System.out.println("The max virtual slot from parition is :" + n);
        int n2 = pIVirtualSerialDataBean.getSlotNumber().intValue();
        System.out.println("The virtual slot number is :" + n2);
        if (n2 < 2 || n2 >= n) {
            String[] stringArray = new String[]{"virtual_scsi_adapters", String.valueOf(n2)};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_SLOT_NUM", stringArray, null);
        }
        UnsignedInt8 unsignedInt8 = pIVirtualSerialDataBean.getDeviceAttributes();
        if (unsignedInt8 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "adapter_type"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        boolean bl = unsignedInt8.intValue() == 1;
        UnsignedInt16 unsignedInt16 = pIVirtualSerialDataBean.getServerPartitionID();
        String string2 = pIVirtualSerialDataBean.getServerPartitionName();
        UnsignedInt16 unsignedInt162 = pIVirtualSerialDataBean.getServerSlotNumber();
        UnsignedInt8 unsignedInt82 = pIVirtualSerialDataBean.getSupportsHMC();
        UnsignedInt8 unsignedInt83 = pIVirtualSerialDataBean.getRequired();
        System.out.println("The is Server value is :" + bl);
        System.out.println("The serverLparID value is :" + unsignedInt16);
        System.out.println("The serverLpar Name is " + string2);
        System.out.println("The Server slot num is " + unsignedInt162);
        System.out.println("The Support HMC " + unsignedInt82);
        System.out.println("The Required value is " + unsignedInt83);
        if (unsignedInt83 == null) {
            String[] stringArray = new String[]{String.valueOf(n2), "is_required"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
        }
        if (bl) {
            System.out.println("Validating server");
            object = null;
            string = null;
            if ((unsignedInt16 != null || string2 != null) && unsignedInt162 == null) {
                object = "remote_slot_num";
            } else if (unsignedInt162 != null && unsignedInt16 == null && string2 == null) {
                object = "remote_lpar_id | remote_lpar_name";
            }
            if (object != null) {
                String[] stringArray = new String[]{String.valueOf(n2), object};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
            }
            if (unsignedInt162 == null) {
                System.out.println("Setting to default server partition id & slot number");
                pIVirtualSerialDataBean.setServerPartitionID(PIVirtualSerialDataBean.DEFAULT_SERVER_PARTITION_ID);
                pIVirtualSerialDataBean.setServerSlotNumber(PIVirtualSerialDataBean.DEFAULT_SERVER_SLOT_NUMBER);
            }
            if (unsignedInt82 == null) {
                pIVirtualSerialDataBean.setSupportsHMC(new UnsignedInt8(0));
            }
        } else {
            System.out.println("Validating client");
            object = "";
            string = "";
            if (unsignedInt16 == null && string2 == null) {
                object = "remote_lpar_id | remote_lpar_name";
            }
            if (unsignedInt162 == null) {
                object = (String)object + ", remote_slot_num";
            }
            if (((String)object).length() > 0) {
                if (((String)object).startsWith(", ")) {
                    object = ((String)object).substring(2, ((String)object).length());
                }
                String[] stringArray = new String[]{String.valueOf(n2), object};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MISSING_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
            }
            if (unsignedInt82 != null && unsignedInt82.intValue() != 0) {
                object = "supports_hmc";
                string = unsignedInt82.toString();
            } else {
                pIVirtualSerialDataBean.setSupportsHMC(new UnsignedInt8(0));
            }
            if (((String)object).length() > 0) {
                String[] stringArray = new String[]{String.valueOf(n2), object, string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_VIRTUAL_ADAPTER_ATTR_VALUE", stringArray, null);
            }
        }
        System.out.println("Checking the validity of the serverpartitionName");
        if (string2 != null && unsignedInt16 == null) {
            pIHSCLPARClient = this.theFactory.createLPARClient(this.m_managedSystem, string2, false);
            System.out.println("The lpar client for server parititon name is :" + pIHSCLPARClient);
            if (pIHSCLPARClient == null) {
                String[] stringArray = new String[]{string2};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
            object = pIHSCLPARClient.getLPARDataBean(new String[]{"lpar_id"});
            string = ((PILPARDataBean)object).getLparID();
            System.out.println("The serverPartition ID is :" + string);
            pIVirtualSerialDataBean.setServerPartitionID((UnsignedInt16)string);
        }
    }

    private void toString(String string, String string2) {
        System.out.println("| chhwres." + string + "()." + string2);
    }

    private void initializeClients() throws PIHscClientException {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theFactory = PIHSCClientObjectFactory.getInstance(string, null);
        if (this.m_operation.equals("a") || this.m_operation.equals("r") || this.m_operation.equals("m") || this.m_resourceType.equals("proc")) {
            this.toString("InitClient", "creating a dlpar client");
            this.m_DlparClient = this.m_sourcePartitionName != null ? this.theFactory.createDLPARClient(this.m_managedSystem, this.m_sourcePartitionName, false) : this.theFactory.createDLPARClient(this.m_managedSystem, this.m_sourcePartitionID, true);
            this.m_sourcePartitionType = this.m_DlparClient.getPartitionType();
            if (null == this.m_DlparClient) {
                this.toString("init", "dlparClient == null");
                throw new PIHscClientException("8000", "PIDLPARBundle", "PARTITION_NOT_FOUND", null, null);
            }
            if (this.m_DlparClient != null && this.m_forceFlag == null) {
                if (this.RPA_PARTITION.equals(this.m_sourcePartitionType) && !this.m_DlparClient.isRMCConnectionExist()) {
                    this.toString("InitClient", "Force flag is null, check for RPA and RMC Connection");
                    this.m_noRMCConnection = true;
                    throw new PIHscClientException("8000", "PIDLPARBundle", "RMC_CONNECTION_DOES_NOT_EXIST", null, null);
                }
            } else if (this.m_DlparClient != null && this.m_forceFlag != null) {
                if (this.RPA_PARTITION.equals(this.m_sourcePartitionType) && !this.m_DlparClient.isRMCConnectionExist()) {
                    this.toString("InitClient", "Force flag is NOT null, check for RPA and RMC");
                    this.m_noRMCConnection = true;
                } else if (!this.RPA_PARTITION.equals(this.m_sourcePartitionType)) {
                    this.toString("InitClient", "Force flag is NOT null, force DLPAR operation.");
                    this.m_noRMCConnection = true;
                }
            } else if (this.m_DlparClient != null) {
                if (!this.m_DlparClient.dlparEnabled(this.m_resourceType)) {
                    this.toString("InitClient", "check for DLPAR capable");
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "ERR_DLPAR_NOT_ENABLED", null, null);
                }
            } else if (this.m_DlparClient != null && this.m_DlparClient.affinityPartition() ? this.m_resourceType.equals("proc") || this.m_resourceType.equals("mem") : this.m_DlparClient != null && this.m_DlparClient.smpPartition()) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "ERR_DLPAR_NOT_ENABLED", null, null);
            }
            if (this.m_operation.equals("m")) {
                try {
                    System.out.println("Creating a DLPAR client for target partition");
                    if (this.m_targetPartitionName != null) {
                        this.m_target = this.theFactory.createDLPARClient(this.m_managedSystem, this.m_targetPartitionName, false);
                        this.m_targetPartitionType = this.m_target.getPartitionType();
                    } else {
                        this.m_target = this.theFactory.createDLPARClient(this.m_managedSystem, this.m_targetPartitionID, true);
                        this.m_targetPartitionType = this.m_target.getPartitionType();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == this.m_target) {
                    throw new PIHscClientException("8000", "PIDLPARBundle", "PARTITION_NOT_FOUND", null, null);
                }
                if (this.m_target != null && !this.m_target.dlparEnabled(this.m_resourceType)) {
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "ERR_DLPAR_NOT_ENABLED", null, null);
                }
                if (this.m_target != null && this.m_forceFlag != null) {
                    this.toString("initClient", "condition 2 in dest client -> check for RPA in dest");
                    if (this.RPA_PARTITION.equals(this.m_targetPartitionType) && !this.m_target.isRMCConnectionExist()) {
                        this.toString("InitClient", "Force flag is null, check for RPA nad RMC");
                        this.m_noRMCConnection = true;
                    }
                } else if (this.m_target != null && this.m_forceFlag == null && this.RPA_PARTITION.equals(this.m_targetPartitionType) && !this.m_target.isRMCConnectionExist()) {
                    this.toString("InitClient", "Force flag is not null, check for RPA and RMC Connection");
                    this.m_noRMCConnection = true;
                    throw new PIHscClientException("8000", "PIDLPARBundle", "RMC_CONNECTION_DOES_NOT_EXIST", null, null);
                }
            }
        } else if ("io".equals(this.m_resourceType)) {
            this.m_lparClient = this.m_sourcePartitionName != null ? this.theFactory.createLPARClient(this.m_managedSystem, this.m_sourcePartitionName, false) : this.theFactory.createLPARClient(this.m_managedSystem, this.m_sourcePartitionID, true);
            if (this.m_lparClient == null) {
                if (this.m_sourcePartitionName != null) {
                    String[] stringArray = new String[]{this.m_sourcePartitionName};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                }
                String[] stringArray = new String[]{this.m_sourcePartitionID};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
            }
        }
        if (!(!"virtualio".equals(this.m_resourceType) || "eth".equals(this.m_resourceSubType) && "s".equals(this.m_operation))) {
            System.out.println("Creating the lparClient for virtual IO");
            if (this.m_sourcePartitionID != null) {
                this.m_LparClient = this.theFactory.createLPARClient(this.m_managedSystem, this.m_sourcePartitionID, true);
            } else if (this.m_sourcePartitionName != null) {
                this.m_LparClient = this.theFactory.createLPARClient(this.m_managedSystem, this.m_sourcePartitionName, false);
            }
            if (this.m_LparClient == null) {
                if (this.m_sourcePartitionName != null) {
                    String[] stringArray = new String[]{this.m_sourcePartitionName};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                }
                String[] stringArray = new String[]{this.m_sourcePartitionID};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
            }
            System.out.println("The lpar client is :" + this.m_LparClient);
        }
    }

    private void performCommand() throws PIHscClientException, HSCRMCException {
        this.checkParameters();
        this.checkCECState();
        this.initializeClients();
        if ("proc".equals(this.m_resourceType)) {
            this.doCPUOperation();
        } else if ("io".equals(this.m_resourceType)) {
            this.doIOOperation();
        } else if ("mem".equals(this.m_resourceType)) {
            this.doMemOperation();
        } else {
            this.doVirtualIOOperation();
        }
    }

    private void checkCECState() throws PIHscClientException {
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if ("a".equals(this.m_operation) || "m".equals(this.m_operation) || "r".equals(this.m_operation)) {
            if (n != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0238", null, null);
            }
        } else if ("io".equals(this.m_resourceType) || "virtualio".equals(this.m_resourceType) && !"eth".equals(this.m_resourceSubType)) {
            if (n != 17 && n != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
            }
        } else if ("virtualio".equals(this.m_resourceType) && "eth".equals(this.m_resourceSubType)) {
            if (n != 17) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0227", null, null);
            }
        } else if (n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0238", null, null);
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType == null || !"proc".equals(this.m_resourceType) && !"io".equals(this.m_resourceType) && !"mem".equals(this.m_resourceType) && !"virtualio".equals(this.m_resourceType)) {
            string = "-r";
        }
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_operation == null || !this.isValidOperation(this.m_operation, this.m_resourceType)) {
            String[] stringArray = new String[]{"-o"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        string = "";
        if (("io".equals(this.m_resourceType) || "virtualio".equals(this.m_resourceType)) && !this.isValidResourceSubType(this.m_resourceSubType, this.m_resourceType, this.m_operation)) {
            string = string + ", --rsubtype";
        }
        if (("proc".equals(this.m_resourceType) || "mem".equals(this.m_resourceType) || "virtualio".equals(this.m_resourceType) && ("a".equals(this.m_operation) || "r".equals(this.m_operation) || "s".equals(this.m_operation) && ("hsl".equals(this.m_resourceSubType) || "virtualopti".equals(this.m_resourceSubType))) || "io".equals(this.m_resourceType)) && (this.m_sourcePartitionName == null || this.m_sourcePartitionName.length() == 0) && (this.m_sourcePartitionID == null || this.m_sourcePartitionID.length() == 0)) {
            string = string + ", -p | --id";
        }
        if (!(!"m".equals(this.m_operation) || this.m_targetPartitionName != null && this.m_targetPartitionName.length() != 0 || this.m_targetPartitionID != null && this.m_targetPartitionID.length() != 0)) {
            string = string + ", -t | --tid";
        }
        if ("virtualio".equals(this.m_resourceType) && !"s".equals(this.m_operation) && (this.m_slot == null || this.m_slot.length() == 0)) {
            string = string + ", -s";
        }
        if ("io".equals(this.m_resourceType) && !"s".equals(this.m_operation) && (this.m_slotLocCode == null || this.m_slotLocCode.length() == 0)) {
            string = string + ", -l";
        }
        if ("mem".equals(this.m_resourceType) && this.m_memQuantity <= 0) {
            string = string + ", -q";
        }
        if (("s".equals(this.m_operation) || "a".equals(this.m_operation) && "virtualio".equals(this.m_resourceType)) && (this.m_attrs == null || this.m_attrs.length() == 0)) {
            string = string + ", -a";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        string = "";
        if (("proc".equals(this.m_resourceType) || "mem".equals(this.m_resourceType)) && this.m_resourceSubType != null) {
            string = "--rsubtype";
        }
        if (("proc".equals(this.m_resourceType) || "mem".equals(this.m_resourceType) || "io".equals(this.m_resourceType)) && this.m_slot != null) {
            string = string + ", -s";
        }
        if (("proc".equals(this.m_resourceType) || "mem".equals(this.m_resourceType) || "virtualio".equals(this.m_resourceType)) && this.m_slotLocCode != null) {
            string = string + ", -l";
        }
        if ("mem".equals(this.m_resourceType) && this.m_attrs != null) {
            string = string + ", -a";
        }
        if (!"mem".equals(this.m_resourceType) && this.m_parms.containsKey("-q")) {
            string = string + ", -q";
        }
        if (!"proc".equals(this.m_resourceType)) {
            if (this.m_parms.containsKey("--procs")) {
                string = string + ", --procs";
            }
            if (this.m_parms.containsKey("--procunits")) {
                string = string + ", --procunits";
            }
            if (this.m_parms.containsKey("--5250cpwpercent")) {
                string = string + ", --5250cpwpercent";
            }
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string, this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
        string = "";
        if (!"m".equals(this.m_operation)) {
            if (this.m_targetPartitionName != null) {
                string = "-t";
            }
            if (this.m_targetPartitionID != null) {
                string = "--tid";
            }
        }
        if (("virtualio".equals(this.m_resourceType) && "r".equals(this.m_operation) || "proc".equals(this.m_resourceType) && !"s".equals(this.m_operation)) && this.m_attrs != null) {
            string = string + ", -a";
        }
        if ("s".equals(this.m_operation) && this.m_slot != null) {
            string = string + ", -s";
        }
        if ("s".equals(this.m_operation) && this.m_slotLocCode != null) {
            string = string + ", -l";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
        }
        if (this.m_sourcePartitionName != null && this.m_sourcePartitionID != null) {
            string = "[-p | --id]";
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        if (this.m_targetPartitionName != null && this.m_targetPartitionID != null) {
            string = "[-t | --tid]";
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        if (this.m_attrs != null && this.m_attrs.length() == 0) {
            String[] stringArray = new String[]{"-a"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private boolean isValidOperation(String string, String string2) {
        boolean bl = false;
        if ("proc".equals(string2) || "io".equals(string2)) {
            if ("a".equals(string) || "m".equals(string) || "r".equals(string) || "s".equals(string)) {
                bl = true;
            }
        } else if ("mem".equals(string2)) {
            if ("a".equals(string) || "m".equals(string) || "r".equals(string)) {
                bl = true;
            }
        } else if ("virtualio".equals(string2)) {
            if ("a".equals(string) || "r".equals(string) || "s".equals(string)) {
                bl = true;
            }
        } else if ("a".equals(string) || "m".equals(string) || "r".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean isValidResourceSubType(String string, String string2, String string3) {
        boolean bl = false;
        if ("io".equals(string2)) {
            if ("s".equals(this.m_operation)) {
                if (string == null || "taggedio".equals(string) || "iopool".equals(string)) {
                    bl = true;
                }
            } else if (string == null || "slot".equals(string)) {
                bl = true;
            }
        } else if ("virtualio".equals(string2)) {
            if ("a".equals(this.m_operation)) {
                if (string != null && ("eth".equals(string) || "scsi".equals(string) || "serial".equals(string))) {
                    bl = true;
                }
            } else if ("r".equals(this.m_operation)) {
                if (string == null || "eth".equals(string) || "scsi".equals(string) || "serial".equals(string)) {
                    bl = true;
                }
            } else if (string != null && ("eth".equals(string) || "hsl".equals(string) || "virtualopti".equals(string))) {
                bl = true;
            }
        }
        return bl;
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        String string = "";
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_operation = (String)hashMap.get("-o");
        this.m_resourceSubType = (String)hashMap.get("--rsubtype");
        this.m_sourcePartitionName = (String)hashMap.get("-p");
        this.m_sourcePartitionID = (String)hashMap.get("--id");
        this.m_targetPartitionName = (String)hashMap.get("-t");
        this.m_targetPartitionID = (String)hashMap.get("--tid");
        this.m_slot = (String)hashMap.get("-s");
        this.m_slotLocCode = (String)hashMap.get("-l");
        this.m_attrs = (String)hashMap.get("-a");
        this.m_forceFlag = (String)hashMap.get("--force");
        String string2 = (String)hashMap.get("-q");
        String string3 = (String)hashMap.get("-w");
        String string4 = (String)hashMap.get("-d");
        String string5 = (String)hashMap.get("--procs");
        String string6 = (String)hashMap.get("--procunits");
        String string7 = (String)hashMap.get("--5250cpwpercent");
        this.m_delimiter = ",";
        if (this.m_slotLocCode != null && this.m_slotLocCode.length() != 0) {
            try {
                long l = Long.parseLong(this.m_slotLocCode, 16);
                String string8 = new Long(l).toString();
                this.m_slotLocCode = new UnsignedInt32(string8).toString();
            }
            catch (NumberFormatException numberFormatException) {
                string = "-l";
            }
        }
        if (string2 != null && string2.length() != 0) {
            try {
                this.m_memQuantity = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = "-q";
            }
        }
        if (string5 != null && string5.length() != 0) {
            try {
                this.m_procQuantity = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                string = "--procs";
            }
        } else {
            this.m_procQuantity = this.NO_PROCS;
        }
        if (string6 != null && string6.length() != 0) {
            try {
                this.m_procUnitsQuantity = PIHMCCommandUtils.decodeTwoDigitPrecisionValue(string6);
            }
            catch (NumberFormatException numberFormatException) {
                string = "--procunits";
            }
        } else {
            this.m_procUnitsQuantity = this.NO_PROC_UNITS;
        }
        if (string7 != null && string7.length() != 0) {
            try {
                this.m_interactive = (int)PIHMCCommandUtils.decodeTwoDigitPrecisionValue(string7);
                if (this.m_interactive > 10000) {
                    String[] stringArray = new String[]{"--5250cpwpercent", String.valueOf(100)};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_INTERACTIVE_PARM_VALUE", stringArray, null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = "--5250cpwpercent";
            }
        } else {
            this.m_interactive = this.NO_INTERACTIVE;
        }
        if (string3 != null) {
            try {
                this.m_timeout = Integer.parseInt(string3);
                if (this.m_timeout < 0) {
                    string = string + ", -w";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = string + ", -w";
            }
        }
        if (string4 != null && string4.length() != 0) {
            try {
                this.m_detailLevel = Short.parseShort(string4);
                if (this.m_detailLevel == 0) {
                    this.m_detailLevel = 1;
                }
                if (this.m_detailLevel < 0 || this.m_detailLevel > 5) {
                    string = string + ", -d";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = string + ", -d";
            }
        }
        this.m_attrData = new Vector();
        if (this.m_attrs != null) {
            this.m_attrData.add(this.m_attrs);
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        if ("led".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHHWRES_LED_TYPE", null, null);
        }
        if ("slot".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHHWRES_SLOT_TYPE", null, null);
        }
        if ("cpu".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHHWRES_CPU_TYPE", null, null);
        }
        String string = (String)hashMap.get("-i");
        if (string != null) {
            String[] stringArray = new String[]{"-l"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHHWRES_I_PARM", stringArray, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHHWRES_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIHardwareConfigurationChange pIHardwareConfigurationChange = new PIHardwareConfigurationChange(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            pIHardwareConfigurationChange.m_parms = PIHMCCommandUtils.parseParameters(arrayList, pIHardwareConfigurationChange.m_validParms);
            pIHardwareConfigurationChange.mapParameters(pIHardwareConfigurationChange.m_parms);
            pIHardwareConfigurationChange.performCommand();
            if (pIHardwareConfigurationChange.m_writeStatus) {
                pIHardwareConfigurationChange.m_writeStatus = false;
                pIHardwareConfigurationChange.m_out.print('\u0000');
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (pIHardwareConfigurationChange.m_writeStatus) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (pIHardwareConfigurationChange.m_writeStatus) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }

    public static long decodeStrValue(String string) {
        if (string == null) {
            return 0L;
        }
        return Long.decode(string);
    }
}

